# Import necessary modules
import hashlib, os, sys, sqlite3, socket, shutil, subprocess, random, ctypes, datetime
from pathlib import Path
# From timeit import timeit

start = datetime.datetime.now()

# Check if script is running under the administrator context
try:
    is_admin = os.getuid() == 0
except:
    is_admin = ctypes.windll.shell32.IsUserAnAdmin() != 0

whoami = os.getlogin()
hostname = socket.gethostname()


# Main function for hash generation
def hash_list(is_admin):
    save_to = open("save_to.txt", "w", encoding="utf-8")
    hash_dictionary = {}
    hash_user_dictionary = {}
    present_dict = {}
    [present_dict.update({hashed: hashed}) for hashed in os.listdir(sys.argv[4])]

    # https://learn.microsoft.com/en-us/windows/deployment/usmt/usmt-recognized-environment-variables
    exclude = {os.environ['PROGRAMDATA'].lower(), os.environ['APPDATA'].lower(), os.environ['LOCALAPPDATA'].lower(),
               os.environ['WINDIR'].lower(), os.environ['TEMP'].lower(), os.environ['PROGRAMFILES'].lower(),
               os.environ['PROGRAMFILES(X86)'].lower(), os.environ['PUBLIC'].lower(),
               os.environ['ALLUSERSPROFILE'].lower()}

    # Testing of extensions for inclusion in backup
    extension = {".cdt", ".indd", ".mpt", ".ppt", ".sxi", ".wps", ".cpt", ".indt", ".mst", ".pptm", ".sxw", ".wpt",
                 ".csv", ".jah", ".pat", ".pptx", ".thmx", ".xla", ".dbf", ".jbh", ".pdf", ".prm", ".vdx", ".xlam",
                 ".doc", ".jbw", ".pmd", ".pub", ".vsd", ".xls", ".docm", ".jfw", ".pot", ".qpw", ".vst", ".xlsb",
                 ".docx", ".jhw", ".potm", ".qxd", ".vsx", ".xlsm", ".dot", ".jtd", ".potx", ".qxt", ".vtx", ".xlsx",
                 ".dotm", ".jtt", ".ppa", ".rtf", ".wcm", ".xlt", ".dotx", ".juw", ".ppam", ".scx", ".wks", ".xltm",
                 ".dwg", ".jvw", ".pps", ".shw", ".wpd", ".xltx", ".dxf", ".lzh", ".ppsm", ".sxd", ".wpg", ".xps",
                 ".has", ".mpp", ".ppsx", ".template", ".pages", ".key", ".numbers", ".kth", ".qdf", ".qif", ".qel",
                 ".qph", ".idx", ".qsd", ".qpd", ".qfp", ".qdt", ".qdb", ".qby", ".qbx", ".exp", ".qbb", ".iif", ".qbw",
                 ".tax", ".tax2008", ".q00", ".q01", ".q03", ".q04", ".q98", ".q99", ".qb1", ".qba", ".qbi", ".qbm",
                 ".qdi", ".qfd", ".qfg", ".qfi", ".qfx", ".qmd", ".qmt", ".qnx", ".qpb", ".qph", ".qtx", ".qw5", ".qw6",
                 ".txt", ".epub", ".CDT", ".INDD", ".MPT", ".PPT", ".SXI", ".WPS", ".CPT", ".INDT", ".MST", ".PPTM",
                 ".SXW", ".WPT", ".CSV", ".JAH", ".PAT", ".PPTX", ".THMX", ".XLA", ".DBF", ".JBH", ".PDF", ".PRM",
                 ".VDX", ".XLAM", ".DOC", ".JBW", ".PMD", ".PUB", ".VSD", ".XLS", ".DOCM", ".JFW", ".POT", ".QPW",
                 ".VST", ".XLSB", ".DOCX", ".JHW", ".POTM", ".QXD", ".VSX", ".XLSM", ".DOT", ".JTD", ".POTX", ".QXT",
                 ".VTX", ".XLSX", ".DOTM", ".JTT", ".PPA", ".RTF", ".WCM", ".XLT", ".DOTX", ".JUW", ".PPAM", ".SCX",
                 ".WKS", ".XLTM", ".DWG", ".JVW", ".PPS", ".SHW", ".WPD", ".XLTX", ".DXF", ".LZH", ".PPSM", ".SXD",
                 ".WPG", ".XPS", ".HAS", ".MPP", ".PPSX", ".TEMPLATE", ".PAGES", ".KEY", ".NUMBERS", ".KTH", ".QDF",
                 ".QIF", ".QEL", ".QPH", ".IDX", ".QSD", ".QPD", ".QFP", ".QDT", ".QDB", ".QBY", ".QBX", ".EXP", ".QBB",
                 ".IIF", ".QBW", ".TAX", ".TAX2008", ".Q00", ".Q01", ".Q03", ".Q04", ".Q98", ".Q99", ".QB1", ".QBA",
                 ".QBI", ".QBM", ".QDI", ".QFD", ".QFG", ".QFI", ".QFX", ".QMD", ".QMT", ".QNX", ".QPB", ".QPH", ".QTX",
                 ".QW5", ".QW6", ".TXT", ".EPUB", ".PST", ".pst"}

    file_failed = 0
    file_existing = 0
    file_new = 0
    file_count = 0
    count = 0
    # Check if path argument is directory
    if sys.argv[1] == '-D' and sys.argv[2] != '' and sys.argv[3] == '-P' and sys.argv[4] != '':
        if sys.argv[2] not in exclude:
            directory = sys.argv[2]
            if not os.path.isdir(directory):
                return print("The path provided is not for a directory")

            # For file count visualization. Will be omitted in final function
            #################################################################

            for path, subdir, files in os.walk(directory):

                # subdir[:] = [d for d in subdir if d not in exclude]
                files = [os.path.join(path, f).lower() for f in files if os.path.splitext(f)[1] in extension]

                for name in files:
                    count += 1
                    for exclusion in exclude:
                        if exclusion not in name:
                            continue
                        else:
                            count -= 1
                            break
            #################################################################

            for path, subdir, files in os.walk(directory):

                # subdir[:] = [d for d in subdir if d not in exclude]
                files = [os.path.join(path, f).lower() for f in files if os.path.splitext(f)[1] in extension]

                for name in files:
                    excluded = False
                    for exclusion in exclude:
                        if exclusion not in name:
                            continue
                        else:
                            excluded = True
                            break

                    if not excluded:
                        file = name.replace('\\', '/').rpartition('/')[2]
                        file_RC = name
                        sub_directory = name.replace('\\', '/').rpartition('/')[0]
                        try:
                            filehash = hashlib.blake2s(open(name, 'rb').read()).hexdigest()
                            if filehash in present_dict:
                                hash_dictionary.update({filehash: (file, sub_directory, size, created, modified)})
                                hash_user_dictionary.update({(file, sub_directory, size, created, modified): filehash})
                                file_existing += 1
                                file_count += 1
                                print(f'A file named "{file}" already exists. ({file_count}/{count})')
                                save_to.write(f'A file named "{file}" already exists. ({file_count}/{count})\n')
                                continue
                            else:
                                shutil.copy(name, sys.argv[4] + filehash)
                                size = os.stat(name).st_size
                                created = os.stat(name).st_ctime
                                modified = os.stat(name).st_mtime
                                hash_dictionary.update({filehash: (file, sub_directory, size, created, modified)})
                                hash_user_dictionary.update({(file, sub_directory, size, created, modified): filehash})
                                present_dict.update({filehash: filehash})
                                file_new += 1
                                file_count += 1
                                print(f'A file named "{file}" has been backed up. ({file_count}/{count})')
                                save_to.write(f'A file named "{file}" has been backed up. ({file_count}/{count})\n')
                        except:  # This exception segment is for locked files that cant be copied directly by Windows copy
                            if not is_admin:
                                file_failed += 1
                                file_count += 1
                                print(
                                    f'A file named "{file}" is locked and could not be backed up. Please try as an "Administrator". ({file_count}/{count})')
                                save_to.write(
                                    f'A file named "{file}" is locked and could not be backed up. Please try as an "Administrator. ({file_count}/{count})\n')
                                continue
                            random_folder = str(random.randint(100000000000, 999999999999))
                            the_file = name.replace("\\", "/")
                            created_folder = sys.argv[4] + "/temp/" + random_folder
                            os.mkdir(created_folder)
                            shell_shadow = ["RawCopy64.exe", f"/FileNamePath:{file_RC}", f"/OutputPath:{created_folder}"]  # TSCopy repo required for this exception
                            subprocess.run(shell_shadow, stdout=subprocess.PIPE, stderr=subprocess.STDOUT, text=True)

                            locked_filename = sys.argv[4] + "/temp/" + random_folder + '/' + file

                            filehash = hashlib.blake2s(open(locked_filename, 'rb').read()).hexdigest()
                            if filehash in present_dict:
                                hash_dictionary.update({filehash: (file, sub_directory, size, created, modified)})
                                hash_user_dictionary.update({(file, sub_directory, size, created, modified): filehash})
                                file_existing += 1
                                file_count += 1
                                shutil.rmtree(sys.argv[4] + "/temp/" + random_folder, ignore_errors=False)
                                print(f'A locked file named "{the_file}" already exists. ({file_count}/{count}) - {filehash}')
                                save_to.write(f'A locked file named "{the_file}" already exists. ({file_count}/{count}) - {filehash}\n')
                                break
                            else:
                                shutil.copy(locked_filename, sys.argv[4] + filehash)
                                size = os.stat(locked_filename).st_size
                                created = os.stat(locked_filename).st_ctime
                                modified = os.stat(locked_filename).st_mtime
                                hash_dictionary.update({filehash: (the_file, sub_directory, size, created, modified)})
                                hash_user_dictionary.update({(the_file, sub_directory, size, created, modified): filehash})
                                shutil.rmtree(sys.argv[4] + "/temp/" + random_folder, ignore_errors=False)
                                present_dict.update({filehash: filehash})
                                file_new += 1
                                file_count += 1
                                print(f'A locked file named "{the_file}" has been backed up. ({file_count}/{count})')
                                save_to.write(f'A locked file named "{the_file}" has been backed up. ({file_count}/{count})\n')

    # Check if path argument is for a file. Code segment is similar to directory code above. Setup a class for optmization
    elif sys.argv[1] == '-F' and sys.argv[2] != '' and sys.argv[3] == '-P' and sys.argv[4] != '':
        # if len(sys.argv[2].rpartition('\\')[0]) > 2 and sys.argv[2].rpartition('\\')[0] not in exclude:
        if len(sys.argv[2].rpartition('\\')[0]) > 2:
            file = sys.argv[2].replace('\\', '/')
            file_RC = sys.argv[2]
            the_file = file.rpartition('/')[2]
            if os.path.isdir(file):
                return print("The path provided is not for a file")
            try:
                filehash = hashlib.blake2s(open(file, 'rb').read()).hexdigest()
                if filehash in present_dict:
                    hash_dictionary.update({filehash: (the_file, file.rpartition('/')[0], size, created, modified)})
                    hash_user_dictionary.update({(the_file, file.rpartition('/')[0], size, created, modified): filehash})
                    print(f'A file named "{the_file}" already exists. (SINGLE)')
                    save_to.write(f'A file named "{the_file}" already exists. (SINGLE)\n')
                else:
                    shutil.copy(file, sys.argv[4] + filehash)
                    size = os.stat(file).st_size
                    created = os.stat(file).st_ctime
                    modified = os.stat(file).st_mtime
                    hash_dictionary.update({filehash: (the_file, file.rpartition('/')[0], size, created, modified)})
                    hash_user_dictionary.update({(the_file, file.rpartition('/')[0], size, created, modified): filehash})
                    present_dict.update({filehash: filehash})
                    save_to.write(f'A file named "{file}" has been created. (SINGLE)\n')
            except:
                if is_admin:
                    random_folder = str(random.randint(100000000000, 999999999999))
                    created_folder = sys.argv[4] + "/temp/" + random_folder
                    created_folder_RC = sys.argv[4] + "\\temp\\" + random_folder
                    os.mkdir(created_folder)
                    # shell_shadow = ["TScopy.exe", "-f", file, "-o", created_folder, "-i"]
                    shell_shadow = ["RawCopy64.exe", f"/FileNamePath:{file_RC}", f"/OutputPath:{created_folder_RC}"]
                    subprocess.run(shell_shadow, stdout=subprocess.PIPE, stderr=subprocess.STDOUT, text=True)

                    # subprocess.call(["C:/Temp/3/Originals/TScopy.exe", "-f", the_file, "-o", created_folder], shell=True)
                    # for temp_path, temp_sub, temp_files in os.walk(created_folder):
                    #     for temp_file in temp_files:
                    #         if not os.path.isfile(created_folder + '/' + temp_file):
                    #             shutil.move(os.path.join(temp_path, temp_file), created_folder)

                    locked_filename = sys.argv[4] + "/temp/" + random_folder + '/' + file.rpartition('/')[2]

                    filehash = hashlib.blake2s(open(locked_filename, 'rb').read()).hexdigest()
                    if filehash in present_dict:
                        hash_dictionary.update({filehash: (file.rpartition('/')[2], file.rpartition('/')[0], size, created, modified)})
                        hash_user_dictionary.update({(file.rpartition('/')[2], file.rpartition('/')[0], size, created, modified): filehash})
                        shutil.rmtree(sys.argv[4] + "/temp/" + random_folder, ignore_errors=False)
                        print(f'A locked file named "{file}" already exists. (SINGLE) - {filehash}')
                        save_to.write(f'A locked file named "{file}" already exist. (SINGLE) - {filehash}\n')
                    else:
                        shutil.copy(locked_filename, sys.argv[4] + filehash)
                        size = os.stat(locked_filename).st_size
                        created = os.stat(locked_filename).st_ctime
                        modified = os.stat(locked_filename).st_mtime
                        shutil.copy(locked_filename, sys.argv[4] + filehash)
                        hash_dictionary.update({filehash: (file.rpartition('/')[2], file.rpartition('/')[0], size, created, modified)})
                        hash_user_dictionary.update({(file.rpartition('/')[2], file.rpartition('/')[0], size, created, modified): filehash})
                        shutil.rmtree(sys.argv[4] + "/temp/" + random_folder, ignore_errors=False)
                        present_dict.update({filehash: filehash})
                        print(f'A locked file named "{file}" has been backed up. (SINGLE)')
                        save_to.write(f'A locked file named "{file}" has been backed up. (SINGLE)\n')
                else:
                    print(f'A file named "{file}" is locked and could not be backed up. Please try as an "Administrator". (SINGLE)')
                    save_to.write(f'A file named "{file}" is locked and could not be backed up. Please try as an "Administrator". (SINGLE)')

    # Arguments provided are neither for a file or a folder
    else:
        print('Arguments provided do not match the required format')

    # For process summary visualization. Will be omitted in final function
    #################################################################
    print(f'The operation has successfully completed on {file_count}/{count} files.')
    save_to.write(f'\nThe operation has successfully completed on {file_count}/{count} files.')
    print(f'{file_new}/{count} new files have been added.')
    save_to.write(f'\n{file_new}/{count} new files have been added.')
    print(f'{file_existing}/{count} existing files have been skipped.')
    save_to.write(f'\n{file_existing}/{count} existing files have been skipped.')
    print(f'{file_failed}/{count} files could not be backed up.')
    save_to.write(f'\n{file_failed}/{count} files could not be backed up.')
    #################################################################

    save_to.close()

    return hash_dictionary, hash_user_dictionary


# Generate the database tables and populate accordingly based on returned dictionaries
def create_update_db(hash_dictionary, hash_user_dictionary, whoami):
    conn = sqlite3.connect('hash.db')
    c = conn.cursor()
    # Hashes table
    c.execute('''CREATE TABLE IF NOT EXISTS hashing (
        checksum TEXT PRIMARY KEY,
        file_size TEXT
        )''')

    # User table
    c.execute('''CREATE TABLE IF NOT EXISTS '{}' (        
        checksum_ID TEXT,        
        filename TEXT,
        location TEXT,
        file_size TEXT,
        file_created TEXT,
        file_modified TEXT,
        FOREIGN KEY(checksum_ID) REFERENCES hashing(checksum) ON DELETE CASCADE ON UPDATE CASCADE,
        FOREIGN KEY(file_size) REFERENCES hashing(file_size),
        UNIQUE(checksum_ID, filename, location)
        )'''.format(whoami))

    conn.commit()

    c.execute('''PRAGMA synchronous = EXTRA''')
    c.execute('''PRAGMA journal_mode = WAL''')

    try:
        for key_ev, value_ev in hash_dictionary.items():
            hash_values = (key_ev, value_ev[2],)
            c.execute("INSERT OR IGNORE INTO hashing VALUES (?,?)", hash_values)
    except:
        pass

    conn.commit()

    try:
        for key_ev, value_ev in hash_user_dictionary.items():
            hash_values = (value_ev, key_ev[0], key_ev[1], key_ev[2], key_ev[3], key_ev[4],)
            c.execute("INSERT OR IGNORE INTO '{}' VALUES (?,?,?,?,?,?)".format(whoami), hash_values)
    except:
        pass

    conn.commit()
    conn.close()


hash_dictionary, hash_user_dictionary = hash_list(is_admin)
create_update_db(hash_dictionary, hash_user_dictionary, whoami)

finish = datetime.datetime.now()

print('\nThe task has completed in:', str(finish-start).rsplit('.')[0])

#gen_tree = input('\nDo you want to generate a directory treeview (not reccomended for more than few hundred files)? y(Yes) / n(No)\n')
#if gen_tree == 'y':
#    shell_tree = ['tree.com', '/A', '/F', sys.argv[2]]  # TSCopy repo required for this exception
#    print(shell_tree)
#    subprocess.run(shell_tree, stdout=subprocess.PIPE, stderr=subprocess.STDOUT, text=True)
#    # list_files(sys.argv[2])
#    print('\nThe task has completed in:', str(finish-start).rsplit('.')[0])
#else:
#    print('\nThe task has completed in:', str(finish-start).rsplit('.')[0])


